<?php
session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg7.php" ?>
<?php include "ewmysql7.php" ?>
<?php include "phpfn7.php" ?>
<?php include "tbl_destinationinfo.php" ?>
<?php include "tbl_admininfo.php" ?>
<?php include "tbl_languageinfo.php" ?>
<?php include "tbl_country_originalinfo.php" ?>
<?php include "userfn7.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Create page object
$tbl_destination_add = new ctbl_destination_add();
$Page =& $tbl_destination_add;

// Page init
$tbl_destination_add->Page_Init();

// Page main
$tbl_destination_add->Page_Main();
?>
<?php include "header.php" ?>
<script type="text/javascript">
<!--

// Create page object
var tbl_destination_add = new ew_Page("tbl_destination_add");

// page properties
tbl_destination_add.PageID = "add"; // page ID
tbl_destination_add.FormID = "ftbl_destinationadd"; // form ID
var EW_PAGE_ID = tbl_destination_add.PageID; // for backward compatibility

// extend page with ValidateForm function
tbl_destination_add.ValidateForm = function(fobj) {
	ew_PostAutoSuggest(fobj);
	if (!this.ValidateRequired)
		return true; // ignore validation
	if (fobj.a_confirm && fobj.a_confirm.value == "F")
		return true;
	var i, elm, aelm, infix;
	var rowcnt = (fobj.key_count) ? Number(fobj.key_count.value) : 1;
	for (i=0; i<rowcnt; i++) {
		infix = (fobj.key_count) ? String(i+1) : "";
		elm = fobj.elements["x" + infix + "_language_id"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->language_id->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_country_id"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->country_id->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_title"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->title->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_page_title"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->page_title->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_photo"];
		aelm = fobj.elements["a" + infix + "_photo"];
		var chk_photo = (aelm && aelm[0])?(aelm[2].checked):true;
		if (elm && chk_photo && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->photo->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_photo"];
		if (elm && !ew_CheckFileType(elm.value))
			return ew_OnError(this, elm, ewLanguage.Phrase("WrongFileType"));
		elm = fobj.elements["x" + infix + "_description"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->description->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_order_by"];
		if (elm && !ew_HasValue(elm))
			return ew_OnError(this, elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($tbl_destination->order_by->FldCaption()) ?>");
		elm = fobj.elements["x" + infix + "_order_by"];
		if (elm && !ew_CheckInteger(elm.value))
			return ew_OnError(this, elm, "<?php echo ew_JsEncode2($tbl_destination->order_by->FldErrMsg()) ?>");

		// Call Form Custom Validate event
		if (!this.Form_CustomValidate(fobj)) return false;
	}
	return true;
}

// extend page with Form_CustomValidate function
tbl_destination_add.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
tbl_destination_add.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
tbl_destination_add.ValidateRequired = false; // no JavaScript validation
<?php } ?>

//-->
</script>
<script type="text/javascript" src="fckeditor/fckeditor.js"></script>
<script type="text/javascript">
<!--
_width_multiplier = 16;
_height_multiplier = 60;
var ew_DHTMLEditors = [];

// update value from editor to textarea
function ew_UpdateTextArea() {
	if (typeof ew_DHTMLEditors != 'undefined' && typeof FCKeditorAPI != 'undefined') {			
			var inst;			
			for (inst in FCKeditorAPI.__Instances)
				FCKeditorAPI.__Instances[inst].UpdateLinkedField();
	}
}

// update value from textarea to editor
function ew_UpdateDHTMLEditor(name) {
	if (typeof ew_DHTMLEditors != 'undefined' && typeof FCKeditorAPI != 'undefined') {
		var inst = FCKeditorAPI.GetInstance(name);		
		if (inst)
			inst.SetHTML(inst.LinkedField.value)
	}
}

// focus editor
function ew_FocusDHTMLEditor(name) {
	if (typeof ew_DHTMLEditors != 'undefined' && typeof FCKeditorAPI != 'undefined') {
		var inst = FCKeditorAPI.GetInstance(name);	
		if (inst && inst.EditorWindow) {
			inst.EditorWindow.focus();
		}
	}
}

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<p><span class="phpmaker"><?php echo $Language->Phrase("Add") ?>&nbsp;<?php echo $Language->Phrase("TblTypeTABLE") ?><?php echo $tbl_destination->TableCaption() ?><br><br>
<a href="<?php echo $tbl_destination->getReturnUrl() ?>"><?php echo $Language->Phrase("GoBack") ?></a></span></p>
<?php
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
$tbl_destination_add->ShowMessage();
?>
<form name="ftbl_destinationadd" id="ftbl_destinationadd" action="<?php echo ew_CurrentPage() ?>" method="post" enctype="multipart/form-data">
<p>
<input type="hidden" name="t" id="t" value="tbl_destination">
<input type="hidden" name="a_add" id="a_add" value="A">
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable">
<?php if ($tbl_destination->language_id->Visible) { // language_id ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->language_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->language_id->CellAttributes() ?>><span id="el_language_id">
<?php if ($tbl_destination->language_id->getSessionValue() <> "") { ?>
<div<?php echo $tbl_destination->language_id->ViewAttributes() ?>><?php echo $tbl_destination->language_id->ViewValue ?></div>
<input type="hidden" id="x_language_id" name="x_language_id" value="<?php echo ew_HtmlEncode($tbl_destination->language_id->CurrentValue) ?>">
<?php } else { ?>
<select id="x_language_id" name="x_language_id" title="<?php echo $tbl_destination->language_id->FldTitle() ?>"<?php echo $tbl_destination->language_id->EditAttributes() ?>>
<?php
if (is_array($tbl_destination->language_id->EditValue)) {
	$arwrk = $tbl_destination->language_id->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($tbl_destination->language_id->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `language_id`, `language`, '' AS Disp2Fld FROM `tbl_language`";
$sWhereWrk = "";
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_language_id" id="s_x_language_id" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_language_id" id="lft_x_language_id" value="">
<?php } ?>
</span><?php echo $tbl_destination->language_id->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($tbl_destination->country_id->Visible) { // country_id ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->country_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->country_id->CellAttributes() ?>><span id="el_country_id">
<?php if ($tbl_destination->country_id->getSessionValue() <> "") { ?>
<div<?php echo $tbl_destination->country_id->ViewAttributes() ?>><?php echo $tbl_destination->country_id->ViewValue ?></div>
<input type="hidden" id="x_country_id" name="x_country_id" value="<?php echo ew_HtmlEncode($tbl_destination->country_id->CurrentValue) ?>">
<?php } else { ?>
<select id="x_country_id" name="x_country_id" title="<?php echo $tbl_destination->country_id->FldTitle() ?>"<?php echo $tbl_destination->country_id->EditAttributes() ?>>
<?php
if (is_array($tbl_destination->country_id->EditValue)) {
	$arwrk = $tbl_destination->country_id->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($tbl_destination->country_id->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<?php
$sSqlWrk = "SELECT `country_or_id`, `country`, '' AS Disp2Fld FROM `tbl_country_original`";
$sWhereWrk = "";
if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
$sSqlWrk = TEAencrypt($sSqlWrk, EW_RANDOM_KEY);
?>
<input type="hidden" name="s_x_country_id" id="s_x_country_id" value="<?php echo $sSqlWrk; ?>">
<input type="hidden" name="lft_x_country_id" id="lft_x_country_id" value="">
<?php } ?>
</span><?php echo $tbl_destination->country_id->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($tbl_destination->title->Visible) { // title ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->title->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->title->CellAttributes() ?>><span id="el_title">
<input type="text" name="x_title" id="x_title" title="<?php echo $tbl_destination->title->FldTitle() ?>" size="75" maxlength="100" value="<?php echo $tbl_destination->title->EditValue ?>"<?php echo $tbl_destination->title->EditAttributes() ?>>
</span><?php echo $tbl_destination->title->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($tbl_destination->page_title->Visible) { // page_title ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->page_title->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->page_title->CellAttributes() ?>><span id="el_page_title">
<input type="text" name="x_page_title" id="x_page_title" title="<?php echo $tbl_destination->page_title->FldTitle() ?>" size="75" maxlength="100" value="<?php echo $tbl_destination->page_title->EditValue ?>"<?php echo $tbl_destination->page_title->EditAttributes() ?>>
</span><?php echo $tbl_destination->page_title->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($tbl_destination->photo->Visible) { // photo ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->photo->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->photo->CellAttributes() ?>><span id="el_photo">
<input type="file" name="x_photo" id="x_photo" title="<?php echo $tbl_destination->photo->FldTitle() ?>" size="30"<?php echo $tbl_destination->photo->EditAttributes() ?>>
</div>
</span><?php echo $tbl_destination->photo->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($tbl_destination->description->Visible) { // description ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->description->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->description->CellAttributes() ?>><span id="el_description">
<textarea name="x_description" id="x_description" title="<?php echo $tbl_destination->description->FldTitle() ?>" cols="35" rows="7"<?php echo $tbl_destination->description->EditAttributes() ?>><?php echo $tbl_destination->description->EditValue ?></textarea>
<script type="text/javascript">
<!--
ew_DHTMLEditors.push(new ew_DHTMLEditor("x_description", function() {
	var sBasePath = 'fckeditor/';
	var oFCKeditor = new FCKeditor('x_description', 35*_width_multiplier, 7*_height_multiplier);
	oFCKeditor.BasePath = sBasePath;
	oFCKeditor.ReplaceTextarea();
	this.active = true;
}));
-->
</script>
</span><?php echo $tbl_destination->description->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($tbl_destination->order_by->Visible) { // order_by ?>
	<tr<?php echo $tbl_destination->RowAttributes() ?>>
		<td class="ewTableHeader"><?php echo $tbl_destination->order_by->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></td>
		<td<?php echo $tbl_destination->order_by->CellAttributes() ?>><span id="el_order_by">
<input type="text" name="x_order_by" id="x_order_by" title="<?php echo $tbl_destination->order_by->FldTitle() ?>" size="75" value="<?php echo $tbl_destination->order_by->EditValue ?>"<?php echo $tbl_destination->order_by->EditAttributes() ?>>
</span><?php echo $tbl_destination->order_by->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</div>
</td></tr></table>
<p>
<input type="button" name="btnAction" id="btnAction" value="<?php echo ew_BtnCaption($Language->Phrase("AddBtn")) ?>" onclick="ew_SubmitForm(tbl_destination_add, this.form);">
</form>
<script language="JavaScript" type="text/javascript">
<!--
ew_UpdateOpts([['x_language_id','x_language_id',false],
['x_country_id','x_country_id',false]]);

//-->
</script>
<script type="text/javascript">
<!--
ew_CreateEditor();  // Create DHTML editor(s)

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php include "footer.php" ?>
<?php
$tbl_destination_add->Page_Terminate();
?>
<?php

//
// Page class
//
class ctbl_destination_add {

	// Page ID
	var $PageID = 'add';

	// Table name
	var $TableName = 'tbl_destination';

	// Page object name
	var $PageObjName = 'tbl_destination_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $tbl_destination;
		if ($tbl_destination->UseTokenInUrl) $PageUrl .= "t=" . $tbl_destination->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show message
	function ShowMessage() {
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage);
		if ($sMessage <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $sMessage . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm, $tbl_destination;
		if ($tbl_destination->UseTokenInUrl) {
			if ($objForm)
				return ($tbl_destination->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($tbl_destination->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function ctbl_destination_add() {
		global $conn, $Language;

		// Language object
		$Language = new cLanguage();

		// Table object (tbl_destination)
		$GLOBALS["tbl_destination"] = new ctbl_destination();

		// Table object (tbl_admin)
		$GLOBALS['tbl_admin'] = new ctbl_admin();

		// Table object (tbl_language)
		$GLOBALS['tbl_language'] = new ctbl_language();

		// Table object (tbl_country_original)
		$GLOBALS['tbl_country_original'] = new ctbl_country_original();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'tbl_destination', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new cTimer();

		// Open connection
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		global $tbl_destination;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		$this->Page_Redirecting($url);
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $sDbMasterFilter = "";
	var $sDbDetailFilter = "";
	var $lPriv = 0;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError, $tbl_destination;

		// Load key values from QueryString
		$bCopy = TRUE;
		if (@$_GET["des_id"] != "") {
		  $tbl_destination->des_id->setQueryStringValue($_GET["des_id"]);
		} else {
		  $bCopy = FALSE;
		}

		// Set up master/detail parameters
		$this->SetUpMasterDetail();

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
		   $tbl_destination->CurrentAction = $_POST["a_add"]; // Get form action
		  $this->GetUploadFiles(); // Get upload files
		  $this->LoadFormValues(); // Load form values

			// Validate form
			if (!$this->ValidateForm()) {
				$tbl_destination->CurrentAction = "I"; // Form error, reset action
				$this->setMessage($gsFormError);
			}
		} else { // Not post back
		  if ($bCopy) {
		    $tbl_destination->CurrentAction = "C"; // Copy record
		  } else {
		    $tbl_destination->CurrentAction = "I"; // Display blank record
		    $this->LoadDefaultValues(); // Load default values
		  }
		}

		// Perform action based on action code
		switch ($tbl_destination->CurrentAction) {
		  case "I": // Blank record, no action required
				break;
		  case "C": // Copy an existing record
		   if (!$this->LoadRow()) { // Load record based on key
		      $this->setMessage($Language->Phrase("NoRecord")); // No record found
		      $this->Page_Terminate("tbl_destinationlist.php"); // No matching record, return to list
		    }
				break;
		  case "A": // ' Add new record
				$tbl_destination->SendEmail = TRUE; // Send email on add success
		    if ($this->AddRow()) { // Add successful
		      $this->setMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $tbl_destination->getReturnUrl();
					$this->Page_Terminate($sReturnUrl); // Clean up and return
		    } else {
		      $this->RestoreFormValues(); // Add failed, restore form values
		    }
		}

		// Render row based on row type
		$tbl_destination->RowType = EW_ROWTYPE_ADD;  // Render add type

		// Render row
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm, $tbl_destination;

		// Get upload data
			if ($tbl_destination->photo->Upload->UploadFile()) {

				// No action required
			} else {
				echo $tbl_destination->photo->Upload->Message;
				$this->Page_Terminate();
				exit();
			}
	}

	// Load default values
	function LoadDefaultValues() {
		global $tbl_destination;
		$tbl_destination->photo->CurrentValue = NULL; // Clear file related field
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm, $tbl_destination;
		$tbl_destination->language_id->setFormValue($objForm->GetValue("x_language_id"));
		$tbl_destination->country_id->setFormValue($objForm->GetValue("x_country_id"));
		$tbl_destination->title->setFormValue($objForm->GetValue("x_title"));
		$tbl_destination->page_title->setFormValue($objForm->GetValue("x_page_title"));
		$tbl_destination->description->setFormValue($objForm->GetValue("x_description"));
		$tbl_destination->order_by->setFormValue($objForm->GetValue("x_order_by"));
		$tbl_destination->des_id->setFormValue($objForm->GetValue("x_des_id"));
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm, $tbl_destination;
		$tbl_destination->des_id->CurrentValue = $tbl_destination->des_id->FormValue;
		$tbl_destination->language_id->CurrentValue = $tbl_destination->language_id->FormValue;
		$tbl_destination->country_id->CurrentValue = $tbl_destination->country_id->FormValue;
		$tbl_destination->title->CurrentValue = $tbl_destination->title->FormValue;
		$tbl_destination->page_title->CurrentValue = $tbl_destination->page_title->FormValue;
		$tbl_destination->description->CurrentValue = $tbl_destination->description->FormValue;
		$tbl_destination->order_by->CurrentValue = $tbl_destination->order_by->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $tbl_destination;
		$sFilter = $tbl_destination->KeyFilter();

		// Call Row Selecting event
		$tbl_destination->Row_Selecting($sFilter);

		// Load SQL based on filter
		$tbl_destination->CurrentFilter = $sFilter;
		$sSql = $tbl_destination->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values

			// Call Row Selected event
			$tbl_destination->Row_Selected($rs);
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn, $tbl_destination;
		$tbl_destination->des_id->setDbValue($rs->fields('des_id'));
		$tbl_destination->language_id->setDbValue($rs->fields('language_id'));
		$tbl_destination->country_id->setDbValue($rs->fields('country_id'));
		$tbl_destination->title->setDbValue($rs->fields('title'));
		$tbl_destination->page_title->setDbValue($rs->fields('page_title'));
		$tbl_destination->photo->Upload->DbValue = $rs->fields('photo');
		$tbl_destination->description->setDbValue($rs->fields('description'));
		$tbl_destination->order_by->setDbValue($rs->fields('order_by'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language, $tbl_destination;

		// Initialize URLs
		// Call Row_Rendering event

		$tbl_destination->Row_Rendering();

		// Common render codes for all row types
		// language_id

		$tbl_destination->language_id->CellCssStyle = ""; $tbl_destination->language_id->CellCssClass = "";
		$tbl_destination->language_id->CellAttrs = array(); $tbl_destination->language_id->ViewAttrs = array(); $tbl_destination->language_id->EditAttrs = array();

		// country_id
		$tbl_destination->country_id->CellCssStyle = ""; $tbl_destination->country_id->CellCssClass = "";
		$tbl_destination->country_id->CellAttrs = array(); $tbl_destination->country_id->ViewAttrs = array(); $tbl_destination->country_id->EditAttrs = array();

		// title
		$tbl_destination->title->CellCssStyle = ""; $tbl_destination->title->CellCssClass = "";
		$tbl_destination->title->CellAttrs = array(); $tbl_destination->title->ViewAttrs = array(); $tbl_destination->title->EditAttrs = array();

		// page_title
		$tbl_destination->page_title->CellCssStyle = ""; $tbl_destination->page_title->CellCssClass = "";
		$tbl_destination->page_title->CellAttrs = array(); $tbl_destination->page_title->ViewAttrs = array(); $tbl_destination->page_title->EditAttrs = array();

		// photo
		$tbl_destination->photo->CellCssStyle = ""; $tbl_destination->photo->CellCssClass = "";
		$tbl_destination->photo->CellAttrs = array(); $tbl_destination->photo->ViewAttrs = array(); $tbl_destination->photo->EditAttrs = array();

		// description
		$tbl_destination->description->CellCssStyle = ""; $tbl_destination->description->CellCssClass = "";
		$tbl_destination->description->CellAttrs = array(); $tbl_destination->description->ViewAttrs = array(); $tbl_destination->description->EditAttrs = array();

		// order_by
		$tbl_destination->order_by->CellCssStyle = ""; $tbl_destination->order_by->CellCssClass = "";
		$tbl_destination->order_by->CellAttrs = array(); $tbl_destination->order_by->ViewAttrs = array(); $tbl_destination->order_by->EditAttrs = array();
		if ($tbl_destination->RowType == EW_ROWTYPE_VIEW) { // View row

			// des_id
			$tbl_destination->des_id->ViewValue = $tbl_destination->des_id->CurrentValue;
			$tbl_destination->des_id->CssStyle = "";
			$tbl_destination->des_id->CssClass = "";
			$tbl_destination->des_id->ViewCustomAttributes = "";

			// language_id
			if (strval($tbl_destination->language_id->CurrentValue) <> "") {
				$sFilterWrk = "`language_id` = " . ew_AdjustSql($tbl_destination->language_id->CurrentValue) . "";
			$sSqlWrk = "SELECT `language` FROM `tbl_language`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				if ($sWhereWrk <> "") $sWhereWrk .= " AND ";
				$sWhereWrk .= "(" . $sFilterWrk . ")";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$tbl_destination->language_id->ViewValue = $rswrk->fields('language');
					$rswrk->Close();
				} else {
					$tbl_destination->language_id->ViewValue = $tbl_destination->language_id->CurrentValue;
				}
			} else {
				$tbl_destination->language_id->ViewValue = NULL;
			}
			$tbl_destination->language_id->CssStyle = "";
			$tbl_destination->language_id->CssClass = "";
			$tbl_destination->language_id->ViewCustomAttributes = "";

			// country_id
			if (strval($tbl_destination->country_id->CurrentValue) <> "") {
				$sFilterWrk = "`country_or_id` = " . ew_AdjustSql($tbl_destination->country_id->CurrentValue) . "";
			$sSqlWrk = "SELECT `country` FROM `tbl_country_original`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				if ($sWhereWrk <> "") $sWhereWrk .= " AND ";
				$sWhereWrk .= "(" . $sFilterWrk . ")";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$tbl_destination->country_id->ViewValue = $rswrk->fields('country');
					$rswrk->Close();
				} else {
					$tbl_destination->country_id->ViewValue = $tbl_destination->country_id->CurrentValue;
				}
			} else {
				$tbl_destination->country_id->ViewValue = NULL;
			}
			$tbl_destination->country_id->CssStyle = "";
			$tbl_destination->country_id->CssClass = "";
			$tbl_destination->country_id->ViewCustomAttributes = "";

			// title
			$tbl_destination->title->ViewValue = $tbl_destination->title->CurrentValue;
			$tbl_destination->title->CssStyle = "";
			$tbl_destination->title->CssClass = "";
			$tbl_destination->title->ViewCustomAttributes = "";

			// page_title
			$tbl_destination->page_title->ViewValue = $tbl_destination->page_title->CurrentValue;
			$tbl_destination->page_title->CssStyle = "";
			$tbl_destination->page_title->CssClass = "";
			$tbl_destination->page_title->ViewCustomAttributes = "";

			// photo
			if (!ew_Empty($tbl_destination->photo->Upload->DbValue)) {
				$tbl_destination->photo->ViewValue = $tbl_destination->photo->Upload->DbValue;
				$tbl_destination->photo->ImageWidth = 200;
				$tbl_destination->photo->ImageHeight = 0;
				$tbl_destination->photo->ImageAlt = $tbl_destination->photo->FldAlt();
			} else {
				$tbl_destination->photo->ViewValue = "";
			}
			$tbl_destination->photo->CssStyle = "";
			$tbl_destination->photo->CssClass = "";
			$tbl_destination->photo->ViewCustomAttributes = "";

			// description
			$tbl_destination->description->ViewValue = $tbl_destination->description->CurrentValue;
			$tbl_destination->description->CssStyle = "";
			$tbl_destination->description->CssClass = "";
			$tbl_destination->description->ViewCustomAttributes = "";

			// order_by
			$tbl_destination->order_by->ViewValue = $tbl_destination->order_by->CurrentValue;
			$tbl_destination->order_by->CssStyle = "";
			$tbl_destination->order_by->CssClass = "";
			$tbl_destination->order_by->ViewCustomAttributes = "";

			// language_id
			$tbl_destination->language_id->HrefValue = "";
			$tbl_destination->language_id->TooltipValue = "";

			// country_id
			$tbl_destination->country_id->HrefValue = "";
			$tbl_destination->country_id->TooltipValue = "";

			// title
			$tbl_destination->title->HrefValue = "";
			$tbl_destination->title->TooltipValue = "";

			// page_title
			$tbl_destination->page_title->HrefValue = "";
			$tbl_destination->page_title->TooltipValue = "";

			// photo
			$tbl_destination->photo->HrefValue = "";
			$tbl_destination->photo->TooltipValue = "";

			// description
			$tbl_destination->description->HrefValue = "";
			$tbl_destination->description->TooltipValue = "";

			// order_by
			$tbl_destination->order_by->HrefValue = "";
			$tbl_destination->order_by->TooltipValue = "";
		} elseif ($tbl_destination->RowType == EW_ROWTYPE_ADD) { // Add row

			// language_id
			$tbl_destination->language_id->EditCustomAttributes = "";
			if ($tbl_destination->language_id->getSessionValue() <> "") {
				$tbl_destination->language_id->CurrentValue = $tbl_destination->language_id->getSessionValue();
			if (strval($tbl_destination->language_id->CurrentValue) <> "") {
				$sFilterWrk = "`language_id` = " . ew_AdjustSql($tbl_destination->language_id->CurrentValue) . "";
			$sSqlWrk = "SELECT `language` FROM `tbl_language`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				if ($sWhereWrk <> "") $sWhereWrk .= " AND ";
				$sWhereWrk .= "(" . $sFilterWrk . ")";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$tbl_destination->language_id->ViewValue = $rswrk->fields('language');
					$rswrk->Close();
				} else {
					$tbl_destination->language_id->ViewValue = $tbl_destination->language_id->CurrentValue;
				}
			} else {
				$tbl_destination->language_id->ViewValue = NULL;
			}
			$tbl_destination->language_id->CssStyle = "";
			$tbl_destination->language_id->CssClass = "";
			$tbl_destination->language_id->ViewCustomAttributes = "";
			} else {
			if (trim(strval($tbl_destination->language_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`language_id` = " . ew_AdjustSql($tbl_destination->language_id->CurrentValue) . "";
			}
			$sSqlWrk = "SELECT `language_id`, `language`, '' AS Disp2Fld, '' AS SelectFilterFld FROM `tbl_language`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				if ($sWhereWrk <> "") $sWhereWrk .= " AND ";
				$sWhereWrk .= "(" . $sFilterWrk . ")";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$tbl_destination->language_id->EditValue = $arwrk;
			}

			// country_id
			$tbl_destination->country_id->EditCustomAttributes = "";
			if ($tbl_destination->country_id->getSessionValue() <> "") {
				$tbl_destination->country_id->CurrentValue = $tbl_destination->country_id->getSessionValue();
			if (strval($tbl_destination->country_id->CurrentValue) <> "") {
				$sFilterWrk = "`country_or_id` = " . ew_AdjustSql($tbl_destination->country_id->CurrentValue) . "";
			$sSqlWrk = "SELECT `country` FROM `tbl_country_original`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				if ($sWhereWrk <> "") $sWhereWrk .= " AND ";
				$sWhereWrk .= "(" . $sFilterWrk . ")";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$tbl_destination->country_id->ViewValue = $rswrk->fields('country');
					$rswrk->Close();
				} else {
					$tbl_destination->country_id->ViewValue = $tbl_destination->country_id->CurrentValue;
				}
			} else {
				$tbl_destination->country_id->ViewValue = NULL;
			}
			$tbl_destination->country_id->CssStyle = "";
			$tbl_destination->country_id->CssClass = "";
			$tbl_destination->country_id->ViewCustomAttributes = "";
			} else {
			if (trim(strval($tbl_destination->country_id->CurrentValue)) == "") {
				$sFilterWrk = "0=1";
			} else {
				$sFilterWrk = "`country_or_id` = " . ew_AdjustSql($tbl_destination->country_id->CurrentValue) . "";
			}
			$sSqlWrk = "SELECT `country_or_id`, `country`, '' AS Disp2Fld, '' AS SelectFilterFld FROM `tbl_country_original`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				if ($sWhereWrk <> "") $sWhereWrk .= " AND ";
				$sWhereWrk .= "(" . $sFilterWrk . ")";
			}
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect")));
			$tbl_destination->country_id->EditValue = $arwrk;
			}

			// title
			$tbl_destination->title->EditCustomAttributes = "";
			$tbl_destination->title->EditValue = ew_HtmlEncode($tbl_destination->title->CurrentValue);

			// page_title
			$tbl_destination->page_title->EditCustomAttributes = "";
			$tbl_destination->page_title->EditValue = ew_HtmlEncode($tbl_destination->page_title->CurrentValue);

			// photo
			$tbl_destination->photo->EditCustomAttributes = "";
			if (!ew_Empty($tbl_destination->photo->Upload->DbValue)) {
				$tbl_destination->photo->EditValue = $tbl_destination->photo->Upload->DbValue;
				$tbl_destination->photo->ImageWidth = 200;
				$tbl_destination->photo->ImageHeight = 0;
				$tbl_destination->photo->ImageAlt = $tbl_destination->photo->FldAlt();
			} else {
				$tbl_destination->photo->EditValue = "";
			}

			// description
			$tbl_destination->description->EditCustomAttributes = "";
			$tbl_destination->description->EditValue = ew_HtmlEncode($tbl_destination->description->CurrentValue);

			// order_by
			$tbl_destination->order_by->EditCustomAttributes = "";
			$tbl_destination->order_by->EditValue = ew_HtmlEncode($tbl_destination->order_by->CurrentValue);
		}

		// Call Row Rendered event
		if ($tbl_destination->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$tbl_destination->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError, $tbl_destination;

		// Initialize form error message
		$gsFormError = "";
		if (!ew_CheckFileType($tbl_destination->photo->Upload->FileName)) {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("WrongFileType");
		}
		if ($tbl_destination->photo->Upload->FileSize > 0 && EW_MAX_FILE_SIZE > 0 && $tbl_destination->photo->Upload->FileSize > EW_MAX_FILE_SIZE) {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= str_replace("%s", EW_MAX_FILE_SIZE, $Language->Phrase("MaxFileSize"));
		}
		if (in_array($tbl_destination->photo->Upload->Error, array(1, 2, 3, 6, 7, 8))) {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("PhpUploadErr" . $tbl_destination->photo->Upload->Error);
		}

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!is_null($tbl_destination->language_id->FormValue) && $tbl_destination->language_id->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->language_id->FldCaption();
		}
		if (!is_null($tbl_destination->country_id->FormValue) && $tbl_destination->country_id->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->country_id->FldCaption();
		}
		if (!is_null($tbl_destination->title->FormValue) && $tbl_destination->title->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->title->FldCaption();
		}
		if (!is_null($tbl_destination->page_title->FormValue) && $tbl_destination->page_title->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->page_title->FldCaption();
		}
		if (is_null($tbl_destination->photo->Upload->Value)) {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->photo->FldCaption();
		}
		if (!is_null($tbl_destination->description->FormValue) && $tbl_destination->description->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->description->FldCaption();
		}
		if (!is_null($tbl_destination->order_by->FormValue) && $tbl_destination->order_by->FormValue == "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $Language->Phrase("EnterRequiredField") . " - " . $tbl_destination->order_by->FldCaption();
		}
		if (!ew_CheckInteger($tbl_destination->order_by->FormValue)) {
			if ($gsFormError <> "") $gsFormError .= "<br>";
			$gsFormError .= $tbl_destination->order_by->FldErrMsg();
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			$gsFormError .= ($gsFormError <> "") ? "<br>" : "";
			$gsFormError .= $sFormCustomError;
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow() {
		global $conn, $Language, $Security, $tbl_destination;
		$rsnew = array();

		// language_id
		$tbl_destination->language_id->SetDbValueDef($rsnew, $tbl_destination->language_id->CurrentValue, 0, FALSE);

		// country_id
		$tbl_destination->country_id->SetDbValueDef($rsnew, $tbl_destination->country_id->CurrentValue, 0, FALSE);

		// title
		$tbl_destination->title->SetDbValueDef($rsnew, $tbl_destination->title->CurrentValue, "", FALSE);

		// page_title
		$tbl_destination->page_title->SetDbValueDef($rsnew, $tbl_destination->page_title->CurrentValue, "", FALSE);

		// photo
		$tbl_destination->photo->Upload->SaveToSession(); // Save file value to Session
		if (is_null($tbl_destination->photo->Upload->Value)) {
			$rsnew['photo'] = NULL;
		} else {
			$rsnew['photo'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $tbl_destination->photo->UploadPath), $tbl_destination->photo->Upload->FileName);
		}
		$tbl_destination->photo->ImageWidth = 340; // Resize width
		$tbl_destination->photo->ImageHeight = 170; // Resize height

		// description
		$tbl_destination->description->SetDbValueDef($rsnew, $tbl_destination->description->CurrentValue, "", FALSE);

		// order_by
		$tbl_destination->order_by->SetDbValueDef($rsnew, $tbl_destination->order_by->CurrentValue, 0, FALSE);

		// Call Row Inserting event
		$bInsertRow = $tbl_destination->Row_Inserting($rsnew);
		if ($bInsertRow) {
			if (!ew_Empty($tbl_destination->photo->Upload->Value)) {
				$tbl_destination->photo->Upload->RestoreFromSession(); // Restore original value
				$tbl_destination->photo->Upload->Resize($tbl_destination->photo->ImageWidth, $tbl_destination->photo->ImageHeight, 75);
			}
			$tbl_destination->photo->ImageWidth = 0; // Reset image width
			$tbl_destination->photo->ImageHeight = 0; // Reset image height
			if (!ew_Empty($tbl_destination->photo->Upload->Value)) {
				if ($tbl_destination->photo->Upload->FileName == $tbl_destination->photo->Upload->DbValue) { // Overwrite if same file name
					$tbl_destination->photo->Upload->SaveToFile($tbl_destination->photo->UploadPath, $rsnew['photo'], TRUE);
					$tbl_destination->photo->Upload->DbValue = ""; // No need to delete any more
				} else {
					$tbl_destination->photo->Upload->SaveToFile($tbl_destination->photo->UploadPath, $rsnew['photo'], FALSE);
				}
			}
			if ($tbl_destination->photo->Upload->Action == "2" || $tbl_destination->photo->Upload->Action == "3") { // Update/Remove
				if ($tbl_destination->photo->Upload->DbValue <> "")
					@unlink(ew_UploadPathEx(TRUE, $tbl_destination->photo->UploadPath) . $tbl_destination->photo->Upload->DbValue);
			}
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $conn->Execute($tbl_destination->InsertSQL($rsnew));
			$conn->raiseErrorFn = '';
		} else {
			if ($tbl_destination->CancelMessage <> "") {
				$this->setMessage($tbl_destination->CancelMessage);
				$tbl_destination->CancelMessage = "";
			} else {
				$this->setMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}
		if ($AddRow) {
			$tbl_destination->des_id->setDbValue($conn->Insert_ID());
			$rsnew['des_id'] = $tbl_destination->des_id->DbValue;

			// Call Row Inserted event
			$tbl_destination->Row_Inserted($rsnew);
		}

		// photo
		$tbl_destination->photo->Upload->RemoveFromSession(); // Remove file value from Session
		return $AddRow;
	}

	// Set up master/detail based on QueryString
	function SetUpMasterDetail() {
		global $tbl_destination;
		$bValidMaster = FALSE;

		// Get the keys for master table
		if (@$_GET[EW_TABLE_SHOW_MASTER] <> "") {
			$sMasterTblVar = $_GET[EW_TABLE_SHOW_MASTER];
			if ($sMasterTblVar == "") {
				$bValidMaster = TRUE;
				$this->sDbMasterFilter = "";
				$this->sDbDetailFilter = "";
			}
			if ($sMasterTblVar == "tbl_language") {
				$bValidMaster = TRUE;
				$this->sDbMasterFilter = $tbl_destination->SqlMasterFilter_tbl_language();
				$this->sDbDetailFilter = $tbl_destination->SqlDetailFilter_tbl_language();
				if (@$_GET["language_id"] <> "") {
					$GLOBALS["tbl_language"]->language_id->setQueryStringValue($_GET["language_id"]);
					$tbl_destination->language_id->setQueryStringValue($GLOBALS["tbl_language"]->language_id->QueryStringValue);
					$tbl_destination->language_id->setSessionValue($tbl_destination->language_id->QueryStringValue);
					if (!is_numeric($GLOBALS["tbl_language"]->language_id->QueryStringValue)) $bValidMaster = FALSE;
					$this->sDbMasterFilter = str_replace("@language_id@", ew_AdjustSql($GLOBALS["tbl_language"]->language_id->QueryStringValue), $this->sDbMasterFilter);
					$this->sDbDetailFilter = str_replace("@language_id@", ew_AdjustSql($GLOBALS["tbl_language"]->language_id->QueryStringValue), $this->sDbDetailFilter);
				} else {
					$bValidMaster = FALSE;
				}
			}
			if ($sMasterTblVar == "tbl_country_original") {
				$bValidMaster = TRUE;
				$this->sDbMasterFilter = $tbl_destination->SqlMasterFilter_tbl_country_original();
				$this->sDbDetailFilter = $tbl_destination->SqlDetailFilter_tbl_country_original();
				if (@$_GET["country_or_id"] <> "") {
					$GLOBALS["tbl_country_original"]->country_or_id->setQueryStringValue($_GET["country_or_id"]);
					$tbl_destination->country_id->setQueryStringValue($GLOBALS["tbl_country_original"]->country_or_id->QueryStringValue);
					$tbl_destination->country_id->setSessionValue($tbl_destination->country_id->QueryStringValue);
					if (!is_numeric($GLOBALS["tbl_country_original"]->country_or_id->QueryStringValue)) $bValidMaster = FALSE;
					$this->sDbMasterFilter = str_replace("@country_or_id@", ew_AdjustSql($GLOBALS["tbl_country_original"]->country_or_id->QueryStringValue), $this->sDbMasterFilter);
					$this->sDbDetailFilter = str_replace("@country_id@", ew_AdjustSql($GLOBALS["tbl_country_original"]->country_or_id->QueryStringValue), $this->sDbDetailFilter);
				} else {
					$bValidMaster = FALSE;
				}
			}
		}
		if ($bValidMaster) {

			// Save current master table
			$tbl_destination->setCurrentMasterTable($sMasterTblVar);

			// Reset start record counter (new master key)
			$this->lStartRec = 1;
			$tbl_destination->setStartRecordNumber($this->lStartRec);
			$tbl_destination->setMasterFilter($this->sDbMasterFilter); // Set up master filter
			$tbl_destination->setDetailFilter($this->sDbDetailFilter); // Set up detail filter

			// Clear previous master key from Session
			if ($sMasterTblVar <> "tbl_language") {
				if ($tbl_destination->language_id->QueryStringValue == "") $tbl_destination->language_id->setSessionValue("");
			}
			if ($sMasterTblVar <> "tbl_country_original") {
				if ($tbl_destination->country_id->QueryStringValue == "") $tbl_destination->country_id->setSessionValue("");
			}
		} else {
			$this->sDbMasterFilter = $tbl_destination->getMasterFilter(); //  Restore master filter
			$this->sDbDetailFilter = $tbl_destination->getDetailFilter(); // Restore detail filter
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	function Message_Showing(&$msg) {

		// Example:
		//$msg = "your new message";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
