<?php
session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include "ewcfg7.php" ?>
<?php include "ewmysql7.php" ?>
<?php include "phpfn7.php" ?>
<?php include "tbl_socialinfo.php" ?>
<?php include "tbl_admininfo.php" ?>
<?php include "userfn7.php" ?>
<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT"); // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // Always modified
header("Cache-Control: private, no-store, no-cache, must-revalidate"); // HTTP/1.1 
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache"); // HTTP/1.0
?>
<?php

// Create page object
$tbl_social_delete = new ctbl_social_delete();
$Page =& $tbl_social_delete;

// Page init
$tbl_social_delete->Page_Init();

// Page main
$tbl_social_delete->Page_Main();
?>
<?php include "header.php" ?>
<script type="text/javascript">
<!--

// Create page object
var tbl_social_delete = new ew_Page("tbl_social_delete");

// page properties
tbl_social_delete.PageID = "delete"; // page ID
tbl_social_delete.FormID = "ftbl_socialdelete"; // form ID
var EW_PAGE_ID = tbl_social_delete.PageID; // for backward compatibility

// extend page with Form_CustomValidate function
tbl_social_delete.Form_CustomValidate =  
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
<?php if (EW_CLIENT_VALIDATE) { ?>
tbl_social_delete.ValidateRequired = true; // uses JavaScript validation
<?php } else { ?>
tbl_social_delete.ValidateRequired = false; // no JavaScript validation
<?php } ?>

//-->
</script>
<script language="JavaScript" type="text/javascript">
<!--

// Write your client script here, no need to add script tags.
// To include another .js script, use:
// ew_ClientScriptInclude("my_javascript.js"); 
//-->

</script>
<?php

// Load records for display
if ($rs = $tbl_social_delete->LoadRecordset())
	$tbl_social_deletelTotalRecs = $rs->RecordCount(); // Get record count
if ($tbl_social_deletelTotalRecs <= 0) { // No record found, exit
	if ($rs)
		$rs->Close();
	$tbl_social_delete->Page_Terminate("tbl_sociallist.php"); // Return to list
}
?>
<p><span class="phpmaker"><?php echo $Language->Phrase("Delete") ?>&nbsp;<?php echo $Language->Phrase("TblTypeTABLE") ?><?php echo $tbl_social->TableCaption() ?><br><br>
<a href="<?php echo $tbl_social->getReturnUrl() ?>"><?php echo $Language->Phrase("GoBack") ?></a></span></p>
<?php
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
$tbl_social_delete->ShowMessage();
?>
<form action="<?php echo ew_CurrentPage() ?>" method="post">
<p>
<input type="hidden" name="t" id="t" value="tbl_social">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($tbl_social_delete->arRecKeys as $key) { ?>
<input type="hidden" name="key_m[]" id="key_m[]" value="<?php echo ew_HtmlEncode($key) ?>">
<?php } ?>
<table class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table cellspacing="0" class="ewTable ewTableSeparate">
<?php echo $tbl_social->TableCustomInnerHtml ?>
	<thead>
	<tr class="ewTableHeader">
		<td valign="top"><?php echo $tbl_social->name->FldCaption() ?></td>
		<td valign="top"><?php echo $tbl_social->link->FldCaption() ?></td>
		<td valign="top"><?php echo $tbl_social->order_by->FldCaption() ?></td>
	</tr>
	</thead>
	<tbody>
<?php
$tbl_social_delete->lRecCnt = 0;
$i = 0;
while (!$rs->EOF) {
	$tbl_social_delete->lRecCnt++;

	// Set row properties
	$tbl_social->CssClass = "";
	$tbl_social->CssStyle = "";
	$tbl_social->RowAttrs = array();
	$tbl_social->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$tbl_social_delete->LoadRowValues($rs);

	// Render row
	$tbl_social_delete->RenderRow();
?>
	<tr<?php echo $tbl_social->RowAttributes() ?>>
		<td<?php echo $tbl_social->name->CellAttributes() ?>>
<div<?php echo $tbl_social->name->ViewAttributes() ?>><?php echo $tbl_social->name->ListViewValue() ?></div></td>
		<td<?php echo $tbl_social->link->CellAttributes() ?>>
<div<?php echo $tbl_social->link->ViewAttributes() ?>><?php echo $tbl_social->link->ListViewValue() ?></div></td>
		<td<?php echo $tbl_social->order_by->CellAttributes() ?>>
<div<?php echo $tbl_social->order_by->ViewAttributes() ?>><?php echo $tbl_social->order_by->ListViewValue() ?></div></td>
	</tr>
<?php
	$rs->MoveNext();
}
$rs->Close();
?>
</tbody>
</table>
</div>
</td></tr></table>
<p>
<input type="submit" name="Action" id="Action" value="<?php echo ew_BtnCaption($Language->Phrase("DeleteBtn")) ?>">
</form>
<script language="JavaScript" type="text/javascript">
<!--

// Write your table-specific startup script here
// document.write("page loaded");
//-->

</script>
<?php include "footer.php" ?>
<?php
$tbl_social_delete->Page_Terminate();
?>
<?php

//
// Page class
//
class ctbl_social_delete {

	// Page ID
	var $PageID = 'delete';

	// Table name
	var $TableName = 'tbl_social';

	// Page object name
	var $PageObjName = 'tbl_social_delete';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		global $tbl_social;
		if ($tbl_social->UseTokenInUrl) $PageUrl .= "t=" . $tbl_social->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		if (@$_SESSION[EW_SESSION_MESSAGE] <> "") { // Append
			$_SESSION[EW_SESSION_MESSAGE] .= "<br>" . $v;
		} else {
			$_SESSION[EW_SESSION_MESSAGE] = $v;
		}
	}

	// Show message
	function ShowMessage() {
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage);
		if ($sMessage <> "") { // Message in Session, display
			echo "<p><span class=\"ewMessage\">" . $sMessage . "</span></p>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm, $tbl_social;
		if ($tbl_social->UseTokenInUrl) {
			if ($objForm)
				return ($tbl_social->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($tbl_social->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function ctbl_social_delete() {
		global $conn, $Language;

		// Language object
		$Language = new cLanguage();

		// Table object (tbl_social)
		$GLOBALS["tbl_social"] = new ctbl_social();

		// Table object (tbl_admin)
		$GLOBALS['tbl_admin'] = new ctbl_admin();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'tbl_social', TRUE);

		// Start timer
		$GLOBALS["gsTimer"] = new cTimer();

		// Open connection
		$conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;
		global $tbl_social;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		$this->Page_Redirecting($url);
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $lTotalRecs = 0;
	var $lRecCnt;
	var $arRecKeys = array();

	//
	// Page main
	//
	function Page_Main() {
		global $Language, $tbl_social;

		// Load key parameters
		$sKey = "";
		$bSingleDelete = TRUE; // Initialize as single delete
		$nKeySelected = 0; // Initialize selected key count
		$sFilter = "";
		if (@$_GET["social_id"] <> "") {
			$tbl_social->social_id->setQueryStringValue($_GET["social_id"]);
			if (!is_numeric($tbl_social->social_id->QueryStringValue))
				$this->Page_Terminate("tbl_sociallist.php"); // Prevent SQL injection, exit
			$sKey .= $tbl_social->social_id->QueryStringValue;
		} else {
			$bSingleDelete = FALSE;
		}
		if ($bSingleDelete) {
			$nKeySelected = 1; // Set up key selected count
			$this->arRecKeys[0] = $sKey;
		} else {
			if (isset($_POST["key_m"])) { // Key in form
				$nKeySelected = count($_POST["key_m"]); // Set up key selected count
				$this->arRecKeys = ew_StripSlashes($_POST["key_m"]);
			}
		}
		if ($nKeySelected <= 0)
			$this->Page_Terminate("tbl_sociallist.php"); // No key specified, return to list

		// Build filter
		foreach ($this->arRecKeys as $sKey) {
			$sFilter .= "(";

			// Set up key field
			$sKeyFld = $sKey;
			if (!is_numeric($sKeyFld))
				$this->Page_Terminate("tbl_sociallist.php"); // Prevent SQL injection, return to list
			$sFilter .= "`social_id`=" . ew_AdjustSql($sKeyFld) . " AND ";
			if (substr($sFilter, -5) == " AND ") $sFilter = substr($sFilter, 0, strlen($sFilter)-5) . ") OR ";
		}
		if (substr($sFilter, -4) == " OR ") $sFilter = substr($sFilter, 0, strlen($sFilter)-4);

		// Set up filter (SQL WHHERE clause) and get return SQL
		// SQL constructor in tbl_social class, tbl_socialinfo.php

		$tbl_social->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$tbl_social->CurrentAction = $_POST["a_delete"];
		} else {
			$tbl_social->CurrentAction = "D"; // Delete record directly
		}
		switch ($tbl_social->CurrentAction) {
			case "D": // Delete
				$tbl_social->SendEmail = TRUE; // Send email on delete success
				if ($this->DeleteRows()) { // delete rows
					$this->setMessage($Language->Phrase("DeleteSuccess")); // Set up success message
					$this->Page_Terminate($tbl_social->getReturnUrl()); // Return to caller
				}
		}
	}

	//
	// Delete records based on current filter
	//
	function DeleteRows() {
		global $conn, $Language, $Security, $tbl_social;
		$DeleteRows = TRUE;
		$sWrkFilter = $tbl_social->CurrentFilter;

		// Set up filter (SQL WHERE clause) and get return SQL
		// SQL constructor in tbl_social class, tbl_socialinfo.php

		$tbl_social->CurrentFilter = $sWrkFilter;
		$sSql = $tbl_social->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setMessage($Language->Phrase("NoRecord")); // No record found
			$rs->Close();
			return FALSE;
		}
		$conn->BeginTrans();

		// Clone old rows
		$rsold = ($rs) ? $rs->GetRows() : array();
		if ($rs)
			$rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $tbl_social->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= EW_COMPOSITE_KEY_SEPARATOR;
				$sThisKey .= $row['social_id'];
				$conn->raiseErrorFn = 'ew_ErrorFn';
				$DeleteRows = $conn->Execute($tbl_social->DeleteSQL($row)); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($tbl_social->CancelMessage <> "") {
				$this->setMessage($tbl_social->CancelMessage);
				$tbl_social->CancelMessage = "";
			} else {
				$this->setMessage($Language->Phrase("DeleteCancelled"));
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$tbl_social->Row_Deleted($row);
			}	
		}
		return $DeleteRows;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn, $tbl_social;

		// Call Recordset Selecting event
		$tbl_social->Recordset_Selecting($tbl_social->CurrentFilter);

		// Load List page SQL
		$sSql = $tbl_social->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $offset, $rowcnt";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$tbl_social->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $tbl_social;
		$sFilter = $tbl_social->KeyFilter();

		// Call Row Selecting event
		$tbl_social->Row_Selecting($sFilter);

		// Load SQL based on filter
		$tbl_social->CurrentFilter = $sFilter;
		$sSql = $tbl_social->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values

			// Call Row Selected event
			$tbl_social->Row_Selected($rs);
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn, $tbl_social;
		$tbl_social->social_id->setDbValue($rs->fields('social_id'));
		$tbl_social->name->setDbValue($rs->fields('name'));
		$tbl_social->link->setDbValue($rs->fields('link'));
		$tbl_social->order_by->setDbValue($rs->fields('order_by'));
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language, $tbl_social;

		// Initialize URLs
		// Call Row_Rendering event

		$tbl_social->Row_Rendering();

		// Common render codes for all row types
		// name

		$tbl_social->name->CellCssStyle = ""; $tbl_social->name->CellCssClass = "";
		$tbl_social->name->CellAttrs = array(); $tbl_social->name->ViewAttrs = array(); $tbl_social->name->EditAttrs = array();

		// link
		$tbl_social->link->CellCssStyle = ""; $tbl_social->link->CellCssClass = "";
		$tbl_social->link->CellAttrs = array(); $tbl_social->link->ViewAttrs = array(); $tbl_social->link->EditAttrs = array();

		// order_by
		$tbl_social->order_by->CellCssStyle = ""; $tbl_social->order_by->CellCssClass = "";
		$tbl_social->order_by->CellAttrs = array(); $tbl_social->order_by->ViewAttrs = array(); $tbl_social->order_by->EditAttrs = array();
		if ($tbl_social->RowType == EW_ROWTYPE_VIEW) { // View row

			// social_id
			$tbl_social->social_id->ViewValue = $tbl_social->social_id->CurrentValue;
			$tbl_social->social_id->CssStyle = "";
			$tbl_social->social_id->CssClass = "";
			$tbl_social->social_id->ViewCustomAttributes = "";

			// name
			if (strval($tbl_social->name->CurrentValue) <> "") {
				switch ($tbl_social->name->CurrentValue) {
					case "fa fa-facebook-square":
						$tbl_social->name->ViewValue = "Facebook";
						break;
					case "fa fa-twitter-square":
						$tbl_social->name->ViewValue = "Twitter";
						break;
					case "fa fa-google-plus-square":
						$tbl_social->name->ViewValue = "Googel plus";
						break;
					case "fa fa-youtube-square":
						$tbl_social->name->ViewValue = "Youtube";
						break;
					case "fa fa-envelope":
						$tbl_social->name->ViewValue = "Envelope";
						break;
					default:
						$tbl_social->name->ViewValue = $tbl_social->name->CurrentValue;
				}
			} else {
				$tbl_social->name->ViewValue = NULL;
			}
			$tbl_social->name->CssStyle = "";
			$tbl_social->name->CssClass = "";
			$tbl_social->name->ViewCustomAttributes = "";

			// link
			$tbl_social->link->ViewValue = $tbl_social->link->CurrentValue;
			$tbl_social->link->CssStyle = "";
			$tbl_social->link->CssClass = "";
			$tbl_social->link->ViewCustomAttributes = "";

			// order_by
			$tbl_social->order_by->ViewValue = $tbl_social->order_by->CurrentValue;
			$tbl_social->order_by->CssStyle = "";
			$tbl_social->order_by->CssClass = "";
			$tbl_social->order_by->ViewCustomAttributes = "";

			// name
			$tbl_social->name->HrefValue = "";
			$tbl_social->name->TooltipValue = "";

			// link
			$tbl_social->link->HrefValue = "";
			$tbl_social->link->TooltipValue = "";

			// order_by
			$tbl_social->order_by->HrefValue = "";
			$tbl_social->order_by->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($tbl_social->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$tbl_social->Row_Rendered();
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	function Message_Showing(&$msg) {

		// Example:
		//$msg = "your new message";

	}
}
?>
